#!/bin/sh
set -x

# Sobe o modulo criando uma 'flash virtual' em RAM.
insmod mtdram.o

# Copia a imagem para a MTD_RAM.
dd if=cmgr_filesystem_tag4.7.2-RC4_r3168.img of=/dev/mtdblock4
rm cmgr_filesystem_tag4.7.2-RC4_r3168.img

# Monta a MTD_RAM e faz o backup da cmgr.
mkdir img
mount -t jffs2 /dev/mtdblock4 img
cmgrconf > img/var/config.bkp
invent --update > img/var/base.cvs
cp /usr/cmgr/flash/aaa.local.user img/usr/cmgr/flash
umount img

# Cria diretorios e copias dos arquivos 
# necessarios para o chroot.
mkdir proc
cp -r /bin /sbin /dev /lib /usr/lib /usr/bin/eraseall .

# Executa o flash.sh em ambiente protegido.
chroot . /flash.sh
exit 0
